# FENtastic Skin for Kodi Omega

**IMPORTANT INFO:** I am currently not accepting **ANY** feature requests.

FENtastic is a modded version of the default Estuary skin, specifically designed for FEN users. It includes several new features and adjustments to pre-existing views, a new UI, viewtypes, customizable widgets, and a new default colors theme.

Below you'll find some information about the [differences](#fentastic-vs-default-estuary-skin) between Estuary and FENtastic along with some screenshots and a detailed [setup guide](#setup-guide) of the skin.


## FENtastic vs Default Estuary Skin

Here are some of the key differences between FENtastic and the default Estuary skin.

* **New UI Experience**: FENtastic introduces an updated modern UI.

  ![Viewtypes Widelist](resources/images/viewtypes1.jpg)

  ![Viewtypes List](resources/images/viewtypes2.jpg)

  ![Viewtypes Widelist](resources/images/viewtypes3.jpg)

  ![Viewtypes List](resources/images/viewtypes4.jpg)

* **New viewtypes**: FENtastic introduces "WideInfoWall" and "WideWall" viewtypes.

  ![Viewtypes WideInfoWall](resources/images/viewtypes.jpg)

* **Customizable Widgets**: FENtastic allows you to customize widgets and category widgets for movies, tvshows, and episodes.

  ![Customizable Widgets](resources/images/customizable_widgets.jpg)

* **Custom Stacked Widgets**: FENtastic introduces stacked widgets for movies and tvshows.

  ![Stacked Widgets](resources/images/stacked_widgets.jpg)

* **Custom Search Window**: FENtastic introduces a search window to simultaneously search multiple categories including TRAKT Lists.

  ![Search Window](resources/images/search_window.jpg)

  ![Search Window](resources/images/search_window1.jpg)

* **InfoPanel with Ratings**: FENtastic introduces a new InfoPanel with optional displaying of ratings for widgets. The ratings can be dislayed in the InfoPanel, widget labels, or both.

  ![InfoPanel](resources/images/infopanel.jpg)

## Features
* NEW UI experience
* 2 NEW viewtypes ("WideWall" and "WideInfoWall")
* Plenty of adjustments to pre-existing views
* Customizable movie and show main menu items
* Customizable widgets and category widgets for movies, tvshows, and episodes
* Custom stacked widgets for movies, tvshows, and episodes
* Ratings displayed for movies, tvshows, seasons, and episodes
* New InfoPanel for widgets
* New custom search window
* Progress displayed for movies, tvshows, seasons and episodes
* Custom Search options from Home window


## Download and installation

To download this skin, go to Settings » File Manager » at the bottom click "Add Source" » then add the source below:

Kodi File Manager Source: [https://ivarbrandt.github.io/repository.ivarbrandt/](https://ivarbrandt.github.io/repository.ivarbrandt/)

![Add Source](resources/images/add_source.jpg)

After adding the source go back to the Settings page » click Addons » Install from zip file » click the source you just added and click "repository.ivarbrandt-1.0.1.zip". This will install my Kodi repo.

![Install from zip](resources/images/install_from_zip.jpg)

Now click Install from repository » Find and click ivarbrandt's Repository » Look and feel » Skin » FENtastic » click to install it.

![Addon Info](resources/images/addon_info.jpg)

On FIRST install go to Settings » Interface » in the Skin section click Configure skin... » Extra info » Setup Guide. Here you will find some tips on setting up your main menu paths and widgets.

   ![Setup Guide](resources/images/setup_guide.jpg)

I have also included a step by step Setup Guide below.

## Setup Guide

On first install, the home screen should be empty. This means that the Movie and Show sections should be missing from the main menu on the left.

![Empty Home Screen](resources/images/empty_home_screen.jpg)

To set up the widgets, follow these steps:

1. From the home screen go to Settings » Interface » in the Skin section click Configure skin... . Here you'll see a group of menu items on the left. Navigate to Main menu items.

   ![Step 1](resources/images/step_1.jpg)

2. Click a menu item to toggle the display of a section on and off. This will show or hide the section on the home screen.

   **NOTE:** Even if you have the Movie/Show section toggled on, you won't see them on the home screen until you set a main menu path for them.

   Toggle the Movie/Show section to 'on'. You'll see a couple of menu items drop down.

   ![Step 2](resources/images/step_2.jpg)

3. To set up the main menu path, click on "Set main menu path." You can set this to whatever path you like within FEN. For example, you might set it to your Trakt movie/tvshow collection.

   ![Step 3](resources/images/step_3.jpg)

4. To set up the movie/tvshow widgets, click on "Set widgets." You can configure up to 10 movie and 10 TV show widgets. After choosing a path, you'll have the option to set the label and display type (Poster, Landscape, LandscapeInfo, and Category) for each widget. If you choose the Category display type, you'll have the option to set it up as a stacked widget. After that, you can choose the display type for the stacked widget as well.

   ![Step 4](resources/images/step_4.jpg)

5. If you would like to rearrange, rename, remake, change display type, or remove a widget after you have set it up, click the widget. You'll see a list of options pop up. Click the desired option. You can reconfigure your widgets as many times as you'd like. You can also rename, remake, or remove the main menu items.

   ![Step 5](resources/images/step_5.jpg)

<!-- ## Rules for Reporting Issues -->

<!-- If you encounter any issues while using FENtastic, please follow these guidelines before opening an Issue:

- Read the **CHANGELOG**. As new updates get released features are added, changed, modified or removed. *Before opening an Issue* related to this make sure you read the changelog (located at the bottom of Skin settings in Extra info) as it will contain information for all the changes made to each update. It is also a good way to stay current with what is new with the skin.
- **Pre-made builds** of any kind are *not supported*. If you installed someone else's build, you need to go to them to troubleshoot issues. These builds often contain a plethora of addons so any number of things could go wrong. Keep in mind this skin was designed exclusively for use with **FEN**.
- Trakt related Issues are *not supported*. These are not skin related. You'll need to contact the developer of the addon that you are experiencing these types of problems/errors with.
- Error related Issues **MUST** include a log file. Your Issue will be closed immediately if you fail to include a log file.
- Make sure to check all open Issues to see if your problem is being addressed already.
- **DO NOT** hijack an open Issue with unrelated problems. Open a new Issue.
- Do your best to **monitor** the Issue you have opened. If I need additional information and it is not supplied within 7 days, I will close the Issue. -->
